ADC.asm
; This program is a simple implementation of the
; PIC18C442's A/D.
; One Channel is selected (AN0).
; The program converts the potentiometer value on RA0 and displays it as
; an 8 bit binary value on Port B.
; The A/D is configured as follows:
; Vref = +5V internal
; A/D Osc. = internal RC
; A/D Channel = AN0 (RA0)
LIST P=18F442
#include <P18F442.INC> ;
TEMP equ 0x000
;************************************************************
org 0x00000 ;
goto Start
org 0x00008 ;
goto ISR ;
;************************************************************
org 0x00020
Start
clrf PORTD ;
clrf TRISD ;
call InitializeAD ;
call SetupDelay ;
call PWM;
bsf ADCON0,GO ;
Main goto Main
;************************************************************
ISR
btfss PIR1,ADIF ; Did A/D cause interrupt?
goto OtherInt ; No, check other sources
movf ADRESH,W ;
movwf CCPR1L
movwf LATD ;
bcf PIR1,ADIF ; Reset A/D int flag
call SetupDelay ;
bsf ADCON0,GO ; Start A/D conversion
goto EndISR ; return from ISR
OtherInt
; This would be replaced by code to check and service
; other interrupt sources
goto $ ; trap here, loops to self
EndISR
retfie ; Return, enables GIE
;************************************************************
; InitializeAD - initializes and sets up the A/D hardware.
; Select AN0 to AN3 as analog inputs, RC clock, and read AN0.
InitializeAD
movlw B'00000100' ;
movwf ADCON1
movlw B'11000001' ;
movwf ADCON0 ; A/D enabled
bcf PIR1,ADIF ; Clear A/D interrupt flag
bsf PIE1,ADIE ; Enable A/D interrupt
bsf INTCON,PEIE ; Enable peripheral interrupts
bsf INTCON,GIE ; Enable Global interrupts
return
;************************************************************
; This is used to allow the A/D time to sample the input (acquisition time).
; This routine requires 11 cycles to complete.
; The call and return add another 4 cycles.
; 15 cycles with Fosc=4MHz means this delay consumes 15us.
SetupDelay
movlw .3 ; Load Temp with decimal 3
movwf TEMP
SD
decfsz TEMP, F ; Delay loop
goto SD
return
;*************************************************************
; This is used to allow PWM routine
PWM
movlw B'11111111'
movwf PR2
movlw B'10000000'
movwf CCPR1L		; CCPR1L register and CCP1CON<5:4> bits.
bcf TRISC,2
bcf T2CON,T2CKPS0	; bit 1-0 T2CKPS1:T2CKPS0: Timer2 Clock Prescale Select bits
bcf T2CON,T2CKPS1	; 00 = Prescaler is 1, 01 = Prescaler is 4, 1x = Prescaler is 16
bsf T2CON,TMR2ON	; Timer2 On bit, 1 = Timer2 is on, 0 = Timer2 is off
movlw B'00001111'
movwf CCP1CON
return

END
